 /*
 *  DDSDemo.c:
 *
 *	DDS Demo with ASM coded loop function
 *  generates a sine wave that oscillates between 100kHz and 1Mhz
 *  uses R2R DAC on GPIO0 .. GPIO7
 *  based on the work of Martin Ossmann
 *  
 *  March 2023 Jürgen Hof, DL8TO
 *
 ***********************************************************************
 */
 #include <stdio.h>
 #include <string.h>
 #include <math.h>
 #include "pico/stdlib.h"
 #include "pico/multicore.h"
 #include "hardware/gpio.h"
 #include "pico/binary_info.h"
 #include "hardware/irq.h" 

 #define FIRST_GPIO 0
 #define SLEEPTIME 10
 #define DDSTABLELEN (1024)
 #define F_LOW  (100000.0)
 #define F_HIGH (1000000.0)
 #define DELTA_F (1000.0)
 
 
 // results in 20MHz DDS-Clk 
 #define cpuClkKhz 140000

extern void loop_fkt(void);
extern uint32_t get_ddstable(void);


#define offset 128
int level=127 ;
float twopi = 2*M_PI ;

uint8_t *DDStable;

float triangle(float x){
  if(x<=M_PI/2){ return x/(M_PI/2.0) ; }
  if(x<=M_PI){ return triangle(M_PI-x) ; }
  return -triangle(2*M_PI-x) ;
  }
  
void setSine(){
  for(int k=0 ; k<DDSTABLELEN ; k++){
    DDStable[k]=((int)(offset+level*sin(twopi*k/DDSTABLELEN))) ;
    }
  }

void setTriangle(){
  for(int k=0 ; k<DDSTABLELEN ; k++){
    DDStable[k]=((int)(offset+level*triangle(twopi*k/DDSTABLELEN))) ;
    }
  }

void setRectangle(){
  for(int k=0 ; k<DDSTABLELEN ; k++){
    if(k<(DDSTABLELEN>>1)){ DDStable[k]=(offset+level) ; }
     else { DDStable[k]=(offset-level); }
    }
  }


int main()
{
	set_sys_clock_khz(cpuClkKhz, true);
    bi_decl(bi_program_description("This is a test binary."));
   

    for (int gpio = FIRST_GPIO; gpio < FIRST_GPIO + 16; gpio++) {
        gpio_init(gpio);
        gpio_set_dir(gpio, GPIO_OUT);
    }   
   
	multicore_launch_core1(loop_fkt); // start DDS

	double ddsclk = 1000.0*cpuClkKhz/7.0;
	
	DDStable = (uint8_t*)get_ddstable(); // get DDSTable
	
	setSine();	          // set waveform
	
    float f = F_LOW;      // start freq 	
	float d = DELTA_F;    // delta 

						
	uint32_t DDSDelta = (uint32_t)((f*4294967296.0)/ddsclk);
	multicore_fifo_push_blocking(DDSDelta);		

					
	while (1)
	{
        sleep_ms(SLEEPTIME);		
		f+=d;
		if (f < F_LOW || f > F_HIGH )  d = -d;
		DDSDelta = (uint32_t)((f*4294967296.0)/ddsclk);
		multicore_fifo_push_blocking(DDSDelta);		
		tight_loop_contents();
	}
	
}
